/**
 * Internal handler for numerical analysis of files
 * CS 184 final project
 * April 16, 2011
 */

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

/**
 * The GUI for the numerator program
 * 
 * @author Ben
 * 
 */
public class NumeratorGUI {

	private static final int IS_EVEN = 0;
	private static final int FIRST_PI = 1;
	private static final int NUM_PI = 2;
	private static final int FIRST_E = 3;
	private static final int NUM_E = 4;
	private static final int TOP_THREE = 5;
	private static final int LENGTH = 6;

	private static final String[] oneFileItems = { "Is the file even?",
			"When does a \"Pi byte\" first occur?",
			"How many \"Pi bytes\" are there?",
			"When does an \"e byte\" first occur?",
			"How many \"e bytes\" are there?",
			"What are the three bytes that occur most often?",
			"How long is the number?" };
	private static final String[] twoFileItems = {
			"Are the files of equal parity?", "Which has a \"Pi byte\" first?",
			"Which contains more \"Pi bytes\"?",
			"Which has an \"e byte\" first?",
			"Which contains more \"e bytes\"?",
			"What three bytes occur most often in both files?",
			"Which file is longer?" };

	private FileNumber fileOne;
	private FileNumber fileTwo;

	private JPanel panel;
	private JPanel filePanelOne;
	private JPanel filePanelTwo;
	private JButton fileButtonOne;
	private JButton fileButtonTwo;
	private JPanel actionPanel;
	private JComboBox oneFileMenu;
	private JComboBox twoFileMenu;
	private JButton oneFileButton;
	private JButton twoFileButton;
	private JScrollPane resultScroll;
	private JTextArea resultArea;
	private JPanel resultPanel;
	private JPanel buttonPanel;

	/**
	 * Method to return the point at which c should be placed for it to be
	 * centered on the screen
	 * 
	 * @param c
	 *            the component being centered
	 * 
	 * @return the location c should be placed at.
	 */
	public static Point getCenteredCorner(Component c) {
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		return new Point((int) ((dim.getWidth() - c.getWidth()) / 2),
				(int) ((dim.getHeight() - c.getHeight()) / 2));
	}

	/**
	 * Method to disable the components that should be disabled at the beginning
	 */
	private void setBoxItemsDisabled() {
		oneFileMenu.setEnabled(false);
		twoFileMenu.setEnabled(false);
		fileButtonTwo.setEnabled(false);
	}

	/**
	 * Method to enable the necessary components after the first file has been
	 * chosen
	 */
	private void setOneFileBoxItemsEnabled() {
		oneFileMenu.setEnabled(true);
		fileButtonTwo.setEnabled(true);
	}

	/**
	 * Method to enable the necessary components after the second file has been
	 * chosen
	 */
	private void setTwoFileBoxItemsEnabled() {
		twoFileMenu.setEnabled(true);
	}

	/**
	 * Method to initialize and placce all components and then display the GUI
	 */
	private void createAndShowGUI() {
		final NumeratorGUI gui = this;
		fileOne = null;
		fileTwo = null;
		panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		filePanelOne = new JPanel(new FlowLayout());
		filePanelTwo = new JPanel(new FlowLayout());
		filePanelOne.setBorder(new TitledBorder("File One"));
		filePanelTwo.setBorder(new TitledBorder("File Two"));
		fileButtonOne = new JButton("Choose a file");
		fileButtonTwo = new JButton("Choose a file");
		filePanelOne.add(fileButtonOne);
		filePanelTwo.add(fileButtonTwo);
		filePanelOne.setSize(new Dimension(50, 20));
		filePanelTwo.setSize(new Dimension(50, 20));
		JPanel filePanel = new JPanel(new FlowLayout());
		filePanel.add(filePanelOne);
		filePanel.add(filePanelTwo);
		actionPanel = new JPanel(new FlowLayout());
		resultPanel = new JPanel(new FlowLayout());
		oneFileMenu = new JComboBox(oneFileItems);
		twoFileMenu = new JComboBox(twoFileItems);
		oneFileMenu.setPreferredSize(new Dimension(300, 20));
		twoFileMenu.setPreferredSize(new Dimension(300, 20));
		actionPanel.add(oneFileMenu);
		actionPanel.add(twoFileMenu);
		buttonPanel = new JPanel(new FlowLayout());
		oneFileButton = new JButton("Calculate");
		twoFileButton = new JButton("Compare");
		buttonPanel.add(oneFileButton);
		buttonPanel.add(twoFileButton);
		resultArea = new JTextArea();
		resultScroll = new JScrollPane(resultArea);
		resultScroll.setPreferredSize(new Dimension(600, 300));
		resultScroll.setBorder(new TitledBorder("Results:"));
		resultScroll
				.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		resultArea.setEditable(false);
		resultPanel.add(resultScroll);
		panel.add(filePanel);
		panel.add(actionPanel);
		panel.add(buttonPanel);
		panel.add(resultPanel);

		fileButtonOne.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				JFileChooser chooser = new JFileChooser();
				int returnVal = chooser.showOpenDialog(panel);
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					fileButtonOne.setEnabled(false);
					fileOne = new FileNumber(chooser.getSelectedFile());
					fileButtonOne.setEnabled(true);
					filePanelOne.setBorder(new TitledBorder(fileOne.getName()));
					gui.setOneFileBoxItemsEnabled();
				}
			}
		});
		fileButtonTwo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				int returnVal = chooser.showOpenDialog(panel);
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					fileTwo = new FileNumber(chooser.getSelectedFile());
					filePanelTwo.setBorder(new TitledBorder(fileTwo.getName()));
					gui.setTwoFileBoxItemsEnabled();
				}
			}
		});

		oneFileButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				oneFileButton.setEnabled(false);
				boolean twoFileButtonWasEnabled = twoFileButton.isEnabled();
				twoFileButton.setEnabled(false);
				int index = oneFileMenu.getSelectedIndex();
				boolean first = false;
				switch (index) {
				case IS_EVEN:
					if (fileOne.isEven())
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + " is even\n");
					else
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + " is not even\n");
					break;
				case FIRST_PI:
					first = true;
					// FALL-THROUGH
				case NUM_PI:
					int firstPi = fileOne.countInstances(first, FileNumber.PI);
					if (firstPi == 0) {
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName()
								+ " contains no instances of Pi\n");
					} else if (firstPi > 0) {
						String str = " has its first Pi (2 bytes) at position "
								+ firstPi + "\n";
						if (!first) {
							str = " has " + firstPi
									+ " instances of Pi (2 bytes)\n";
						}
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + str);
					}
					break;
				case FIRST_E:
					first = true;
					// FALL-THROUGH
				case NUM_E:
					int firstE = fileOne.countInstances(first, FileNumber.E);
					if (firstE == 0) {
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName()
								+ " contains no instances of e\n");
					} else if (firstE > 0) {
						String str = " has its first e (2 bytes) at position "
								+ firstE + "\n";
						if (!first) {
							str = " has " + firstE
									+ " instances of e (2 bytes)\n";
						}
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + str);
					}
					break;
				case TOP_THREE:
					int[] topThree = fileOne.topThreeBytes();
					resultArea.setText(resultArea.getText() + "File "
							+ fileOne.getName() + " has " + (byte) topThree[0]
							+ ", " + (byte) topThree[1] + ", "
							+ (byte) topThree[2]
							+ " as its most common bytes\n");
					Color color = new Color(topThree[0], topThree[1],
							topThree[2]);
					JFrame colorFrame = new JFrame();
					colorFrame.setSize(new Dimension(500, 500));
					colorFrame.setTitle(fileOne.getName());
					JPanel colorPanel = new JPanel();
					colorPanel.setBackground(color);
					colorFrame.setContentPane(colorPanel);
					colorFrame.setVisible(true);
					break;
				case LENGTH:
					int len = (int) Math.log10(Math.pow(2, fileOne.getLength()));
					int pages = len / 3000;
					resultArea.setText(resultArea.getText() + "File "
							+ fileOne.getName() + " is " + len
							+ " digits long, or " + pages + " pages.\n");
					break;
				default:
					break;
				}
				oneFileButton.setEnabled(true);
				twoFileButton.setEnabled(twoFileButtonWasEnabled);
			}
		});

		twoFileButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				twoFileButton.setEnabled(false);
				oneFileButton.setEnabled(false);
				int index = twoFileMenu.getSelectedIndex();
				boolean first = false;
				switch (index) {
				case IS_EVEN:
					boolean oneEven = fileOne.isEven();
					String oneEvenString = "even";
					if (!oneEven) {
						oneEvenString = "odd";
					}
					boolean twoEven = fileTwo.isEven();
					String twoEvenString = "even";
					if (!twoEven) {
						twoEvenString = "odd";
					}
					if ((oneEven && twoEven) || (!oneEven && !twoEven))
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + " and file "
								+ fileTwo.getName() + " are both "
								+ oneEvenString + ".\n");
					else
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + " is " + oneEvenString
								+ ", but file " + fileTwo.getName() + " is "
								+ twoEvenString + ".\n");
					break;
				case FIRST_PI:
					first = true;
					// FALL-THROUGH
				case NUM_PI:
					int firstPiOne = fileOne.countInstances(first,
							FileNumber.PI);
					int firstPiTwo = fileTwo.countInstances(first,
							FileNumber.PI);
					if (firstPiOne == 0 && firstPiTwo == 0) {
						resultArea.setText(resultArea.getText()
								+ "Neither file " + fileOne.getName()
								+ " nor file " + fileTwo.getName()
								+ " contains any instances of Pi\n");
					} else if (firstPiOne == 0) {
						String str = "has";
						if (first)
							str = "has one at";
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName()
								+ " contains no instances of Pi, but file "
								+ fileTwo.getName() + " " + str + " "
								+ firstPiTwo + ".\n");
					} else if (firstPiTwo == 0) {
						String str = "has";
						if (first)
							str = "has one at";
						resultArea.setText(resultArea.getText() + "File "
								+ fileTwo.getName()
								+ " contains no instances of Pi, but file "
								+ fileOne.getName() + " " + str + " "
								+ firstPiOne + ".\n");
					} else if (first) {
						String comp = "at the same position that";
						if (firstPiOne < firstPiTwo) {
							int diff = firstPiTwo - firstPiOne;
							comp = diff + " places before";
						} else if (firstPiOne > firstPiTwo) {
							int diff = firstPiOne - firstPiTwo;
							comp = diff + " places after";
						}
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName()
								+ " has its first occurance of Pi at "
								+ firstPiOne + ", " + comp + " file "
								+ fileTwo.getName() + " does, at " + firstPiTwo
								+ ".\n");
					} else {
						String comp = "the same number as";
						if (firstPiOne < firstPiTwo) {
							int diff = firstPiTwo - firstPiOne;
							comp = diff + " fewer than";
						} else if (firstPiOne > firstPiTwo) {
							int diff = firstPiOne - firstPiTwo;
							comp = diff + " more than";
						}
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + " has " + firstPiOne
								+ " instances of Pi, " + comp + " file "
								+ fileTwo.getName() + " does, at " + firstPiTwo
								+ ".\n");
					}
					break;
				case FIRST_E:
					first = true;
					// FALL-THROUGH
				case NUM_E:
					int firstEOne = fileOne.countInstances(first, FileNumber.E);
					int firstETwo = fileTwo.countInstances(first, FileNumber.E);
					if (firstEOne == 0 && firstETwo == 0) {
						resultArea.setText(resultArea.getText()
								+ "Neither file " + fileOne.getName()
								+ " nor file " + fileTwo.getName()
								+ " contains any instances of e\n");
					} else if (firstEOne == 0) {
						String str = "has";
						if (first)
							str = "has one at";
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName()
								+ " contains no instances of e, but file "
								+ fileTwo.getName() + " " + str + " "
								+ firstETwo + ".\n");
					} else if (firstETwo == 0) {
						String str = "has";
						if (first)
							str = "has one at";
						resultArea.setText(resultArea.getText() + "File "
								+ fileTwo.getName()
								+ " contains no instances of e, but file "
								+ fileOne.getName() + " " + str + " "
								+ firstEOne + ".\n");
					} else if (first) {
						String comp = "at the same position that";
						if (firstEOne < firstETwo) {
							int diff = firstETwo - firstEOne;
							comp = diff + " places before";
						} else if (firstEOne > firstETwo) {
							int diff = firstEOne - firstETwo;
							comp = diff + " places after";
						}
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName()
								+ " has its first occurance of e at "
								+ firstEOne + ", " + comp + " file "
								+ fileTwo.getName() + " does, at " + firstETwo
								+ ".\n");
					} else {
						String comp = "the same number as";
						if (firstEOne < firstETwo) {
							int diff = firstETwo - firstEOne;
							comp = diff + " fewer than";
						} else if (firstEOne > firstETwo) {
							int diff = firstEOne - firstETwo;
							comp = diff + " more than";
						}
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + " has " + firstEOne
								+ " instances of e, " + comp + " file "
								+ fileTwo.getName() + " does, at " + firstETwo
								+ ".\n");
					}
					break;
				case TOP_THREE:
					int[] topThreeOne = fileOne.topThreeBytes();
					int[] topThreeTwo = fileTwo.topThreeBytes();
					int[] topThree = new int[topThreeOne.length];
					for (int i = 0; i < topThree.length; i++) {
						topThree[i] = topThreeOne[i] + topThreeTwo[i];
					}
					resultArea.setText(resultArea.getText() + "Files "
							+ fileOne.getName() + " and " + fileTwo.getName()
							+ " have " + (byte) topThree[0] + ", "
							+ (byte) topThree[1] + ", " + (byte) topThree[2]
							+ " as their most common bytes\n");
					Color color = new Color(topThree[0], topThree[1],
							topThree[2]);
					JFrame colorFrame = new JFrame();
					colorFrame.setSize(new Dimension(500, 500));
					colorFrame.setTitle(fileOne.getName());
					JPanel colorPanel = new JPanel();
					colorPanel.setBackground(color);
					colorFrame.setContentPane(colorPanel);
					colorFrame.setVisible(true);
					break;
				case LENGTH:
					long l1 = fileOne.getLength();
					long l2 = fileTwo.getLength();
					if (l1 > l2) {
						long diff = fileOne.getLength() - fileTwo.getLength();
						resultArea.setText(resultArea.getText() + "File "
								+ fileOne.getName() + " is longer by " + diff
								+ " bytes.\n");
					} else if (l1 < l2) {
						long diff = fileTwo.getLength() - fileOne.getLength();
						resultArea.setText(resultArea.getText() + "File "
								+ fileTwo.getName() + " is longer by " + diff
								+ " bytes.\n");
					} else {
						resultArea.setText(resultArea.getText() + "Files "
								+ fileOne.getName() + " and "
								+ fileTwo.getName() + " are the same length.\n");
					}
					break;
				default:
					break;
				}
				twoFileButton.setEnabled(true);
				oneFileButton.setEnabled(true);
			}
		});

		// Create and set up the window.
		JFrame frame = new JFrame("Numerator");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setResizable(false);

		// Set up the content pane.
		panel.setOpaque(true); // content panes must be opaque
		frame.setContentPane(panel);

		setBoxItemsDisabled();

		frame.pack();
		frame.setLocation(getCenteredCorner(frame));
		frame.setVisible(true);
	}

	/**
	 * Main method
	 * 
	 * @param args
	 *            the command-line arguments
	 */
	public static void main(String[] args) {
		// Schedule a job for the event-dispatching thread:
		// creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				NumeratorGUI gui = new NumeratorGUI();
				gui.createAndShowGUI();
			}
		});
	}
}
