/**
 * Internal handler for numerical analysis of files
 * CS 184 final project
 * April 16, 2011
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

/**
 * The class that stores the file and provides methods to do the analysis on it.
 * 
 * @author Ben
 * 
 */
public class FileNumber {

	public static final int PI = 0;
	public static final int E = 1;

	private static final byte[] PI_ARRAY = { 73, 15 };// , -40 };
	private static final byte[] E_ARRAY = { 45, -8 };// , 84 };

	private File file;
	private long length;

	/**
	 * Constructor
	 * 
	 * @param file
	 *            the file we are using for this FileNumber
	 */
	public FileNumber(File file) {
		this.file = file;
		length = file.length();
	}

	/**
	 * Method to determine whether the file is even
	 * 
	 * @return whether the file is even
	 */
	public boolean isEven() {
		try {
			FileInputStream stream = new FileInputStream(file);
			stream.skip(length - 1);
			int c = stream.read();
			int half_c = c / 2;
			return half_c * 2 == c;
		} catch (IOException e) {
			System.err.println("Error in isEven");
			e.printStackTrace();
			return false;
		}
	}

	/**
	 * Method to return the count of each byte in the file
	 * 
	 * @return a 256-int long array, each slot as the number of occurances of
	 *         the byte of the slot's index number
	 */
	public int[] byteCount() {
		int[] array = new int[256];
		try {
			int c;
			FileInputStream stream = new FileInputStream(file);
			while ((c = stream.read()) >= 0) {
				array[c]++;
			}
		} catch (Exception e) {
			;
		}
		for (int i = 0; i < 256; i++) {
			System.out.println((byte) i + ":" + array[i]);
		}
		return array;
	}

	/**
	 * Method to calculate the median of an array of ints
	 * 
	 * @param array
	 * @return the median
	 */
	public int calculateMedian(int[] array) {
		ArrayList<Integer> list = new ArrayList<Integer>();
		for (int i = 0; i < array.length; i++) {
			list.add(array[i]);
		}
		Collections.sort(list);
		return list.get(array.length / 2);
	}

	/**
	 * Method to calculate the top three bytes, disregarding outliers (those
	 * with frequencies of 50% greater than the median and above)
	 * 
	 * @return
	 */
	public int[] topThreeBytes() {
		int[] topThree = { 0, 0, 0 };
		int[] topThreeVals = { 0, 0, 0 };
		int[] array = byteCount();
		int median = calculateMedian(array);
		int max = median * 3 / 2;
		for (int i = 0; i < array.length; i++) {
			int val = array[i];
			if (val > max)
				continue; // Ignore outliers
			if (val > topThreeVals[0]) {
				topThreeVals[2] = topThreeVals[1];
				topThreeVals[1] = topThreeVals[0];
				topThreeVals[0] = val;
				topThree[2] = topThree[1];
				topThree[1] = topThree[0];
				topThree[0] = i;
			} else if (val > topThreeVals[1]) {
				topThreeVals[2] = topThreeVals[1];
				topThreeVals[1] = val;
				topThree[2] = topThree[1];
				topThree[1] = i;
			} else if (val > topThreeVals[2]) {
				topThreeVals[2] = val;
				topThree[2] = i;
			}
		}
		return topThree;
	}

	/**
	 * Method to find instances of a two-byte number <code>number</code> in the
	 * file.
	 * 
	 * @param first
	 *            whether to quit after the first instance is found and return
	 *            its index, or count the total number of instances
	 * @param number
	 *            the number we are looking for
	 * @return either the first index of number or the number of occurrences,
	 *         depending on the value of <code>first</code>
	 */
	public int countInstances(boolean first, int number) {
		byte[] byteArray = { 0, 0 };
		switch (number) {
		case PI:
			byteArray = PI_ARRAY;
			break;
		case E:
			byteArray = E_ARRAY;
			break;
		default:
			System.err.println("Invalid number argument to countInstances");
			return -1;
		}
		int num = 0;
		int pos = 0;
		int numBytesSoFar = 0;
		try {
			int c;
			FileInputStream stream = new FileInputStream(file);
			while ((c = stream.read()) >= 0) {
				if (c == byteArray[0]) {
					numBytesSoFar = 1;
				} else if (numBytesSoFar == 1 && ((byte) c) == byteArray[1]) {
					// numBytesSoFar = 2;
					// } else if (numBytesSoFar == 2 && c == PI[2]) {
					if (first) {
						return pos;
					}
					num++;
				} else {
					numBytesSoFar = 0;
				}
				pos++;
			}
			return num;
		} catch (IOException e) {
			System.err.println("Error in firstPi");
			e.printStackTrace();
			return -1;
		}
	}

	/**
	 * Accessor method for the file's name (necessary because the file itself is
	 * private
	 * 
	 * @return the name of the file
	 */
	public String getName() {
		return file.getName();
	}
	
	/**
	 * Accessor method for the file's length (necessary because the file itself is
	 * private
	 * 
	 * @return the length (in bytes) of the file
	 */
	public long getLength() {
		return length;
	}
}
